/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import jxl.CellReferenceHelper;
import jxl.Hyperlink;
import jxl.Range;
import jxl.Sheet;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.SheetRangeImpl;
import jxl.biff.StringHelper;
import jxl.read.biff.Record;

public class HyperlinkRecord
extends RecordData
implements Hyperlink {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$HyperlinkRecord == null ? (class$jxl$read$biff$HyperlinkRecord = HyperlinkRecord.class$("jxl.read.biff.HyperlinkRecord")) : class$jxl$read$biff$HyperlinkRecord);
    private int firstRow;
    private int lastRow;
    private int firstColumn;
    private int lastColumn;
    private URL url;
    private File file;
    private String location;
    private SheetRangeImpl range;
    private LinkType linkType = unknown;
    private static final LinkType urlLink = new LinkType();
    private static final LinkType fileLink = new LinkType();
    private static final LinkType workbookLink = new LinkType();
    private static final LinkType unknown = new LinkType();
    static /* synthetic */ Class class$jxl$read$biff$HyperlinkRecord;

    HyperlinkRecord(Record t, Sheet s, WorkbookSettings ws) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.firstRow = IntegerHelper.getInt(data[0], data[1]);
        this.lastRow = IntegerHelper.getInt(data[2], data[3]);
        this.firstColumn = IntegerHelper.getInt(data[4], data[5]);
        this.lastColumn = IntegerHelper.getInt(data[6], data[7]);
        this.range = new SheetRangeImpl(s, this.firstColumn, this.firstRow, this.lastColumn, this.lastRow);
        if ((data[28] & 3) == 3) {
            this.linkType = urlLink;
            boolean description = (data[28] & 0x14) != 0;
            String urlString = null;
            try {
                int startpos = 32;
                if (description) {
                    int descbytes = IntegerHelper.getInt(data[startpos], data[startpos + 1], data[startpos + 2], data[startpos + 3]);
                    startpos += descbytes * 2 + 4;
                }
                int bytes = IntegerHelper.getInt(data[startpos += 16], data[startpos + 1], data[startpos + 2], data[startpos + 3]);
                urlString = StringHelper.getUnicodeString(data, bytes / 2 - 1, startpos + 4);
                this.url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                logger.warn("URL " + urlString + " is malformed.  Using default.");
                try {
                    this.url = new URL("http://www.andykhan.com/jexcelapi/index.html");
                }
                catch (MalformedURLException e2) {
                }
            }
            catch (Throwable e) {
                StringBuffer sb1 = new StringBuffer();
                StringBuffer sb2 = new StringBuffer();
                CellReferenceHelper.getCellReference(this.firstColumn, this.firstRow, sb1);
                CellReferenceHelper.getCellReference(this.lastColumn, this.lastRow, sb2);
                sb1.insert(0, "Exception when parsing URL ");
                sb1.append('\"').append(sb2.toString()).append("\".  Using default.");
                logger.warn(sb1, e);
                try {
                    this.url = new URL("http://www.andykhan.com/jexcelapi/index.html");
                }
                catch (MalformedURLException e2) {}
            }
        } else if ((data[28] & 1) != 0) {
            this.linkType = fileLink;
            boolean description = (data[28] & 0x14) != 0;
            try {
                int startpos = 48;
                int upLevelCount = IntegerHelper.getInt(data[startpos], data[startpos + 1]);
                int chars = IntegerHelper.getInt(data[startpos + 2], data[startpos + 3], data[startpos + 4], data[startpos + 5]);
                String fileName = StringHelper.getString(data, chars - 1, startpos + 6, ws);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < upLevelCount; ++i) {
                    sb.append("..\\");
                }
                sb.append(fileName);
                this.file = new File(sb.toString());
            }
            catch (Throwable e) {
                logger.warn("Exception when parsing file " + e.getClass().getName() + ".");
                this.file = new File(".");
            }
        } else if ((data[28] & 8) != 0) {
            this.linkType = workbookLink;
            int chars = IntegerHelper.getInt(data[32], data[33], data[34], data[35]);
            this.location = StringHelper.getUnicodeString(data, chars - 1, 36);
        } else {
            logger.warn("Cannot determine link type");
            return;
        }
    }

    public boolean isFile() {
        return this.linkType == fileLink;
    }

    public boolean isURL() {
        return this.linkType == urlLink;
    }

    public boolean isLocation() {
        return this.linkType == workbookLink;
    }

    public int getRow() {
        return this.firstRow;
    }

    public int getColumn() {
        return this.firstColumn;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public int getLastColumn() {
        return this.lastColumn;
    }

    public URL getURL() {
        return this.url;
    }

    public File getFile() {
        return this.file;
    }

    public Record getRecord() {
        return super.getRecord();
    }

    public Range getRange() {
        return this.range;
    }

    public String getLocation() {
        return this.location;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LinkType {
        private LinkType() {
        }
    }
}

