/*
 * Decompiled with CFR 0.152.
 */
package com.unionpay.acp.gwj.util;

import com.unionpay.acp.gwj.conf.GwjConfig;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.log4j.Logger;

public class HttpUtil {
    private static final Logger logger = Logger.getLogger(HttpUtil.class);
    public static String encoding;
    private static String GWJ_CID;
    private static String GWJ_CODE;
    private static final HttpConnectionManager connectionManager;
    private static final HttpClient client;

    private static HttpConnectionManagerParams loadHttpConfFromFile() {
        Properties p = new Properties();
        try {
            p.load(HttpUtil.class.getResourceAsStream(HttpUtil.class.getSimpleName().toLowerCase() + ".properties"));
        }
        catch (IOException e) {
            // empty catch block
        }
        encoding = p.getProperty("http.content.encoding");
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setConnectionTimeout(Integer.parseInt(p.getProperty("http.connection.timeout")));
        params.setSoTimeout(Integer.parseInt(p.getProperty("http.so.timeout")));
        params.setStaleCheckingEnabled(Boolean.parseBoolean(p.getProperty("http.stale.check.enabled")));
        params.setTcpNoDelay(Boolean.parseBoolean(p.getProperty("http.tcp.no.delay")));
        params.setDefaultMaxConnectionsPerHost(Integer.parseInt(p.getProperty("http.default.max.connections.per.host")));
        params.setMaxTotalConnections(Integer.parseInt(p.getProperty("http.max.total.connections")));
        params.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        return params;
    }

    public static String post(String url, String encoding, String content) {
        try {
            byte[] resp = HttpUtil.post(url, content.getBytes(encoding));
            if (null == resp) {
                return null;
            }
            return new String(resp, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String post(String url, String content) {
        return HttpUtil.post(url, encoding, content);
    }

    public static byte[] post(String url, byte[] content) {
        try {
            byte[] ret = HttpUtil.post(url, (RequestEntity)new ByteArrayRequestEntity(content));
            return ret;
        }
        catch (Exception e) {
            logger.warn((Object)("Catch exception while post to url [" + url + "]"), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] post(String url, RequestEntity requestEntity) throws Exception {
        PostMethod method = new PostMethod(url);
        method.addRequestHeader("Connection", "Keep-Alive");
        method.getParams().setCookiePolicy("ignoreCookies");
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        method.setRequestEntity(requestEntity);
        method.addRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        method.setRequestHeader(GWJ_CID, GwjConfig.GWJ_CID);
        method.setRequestHeader(GWJ_CODE, GwjConfig.GWJ_CODE);
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                logger.warn((Object)("Http response status is not OK [" + statusCode + "]"));
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    public static String getAsString(String url) {
        try {
            return new String(HttpUtil.get(url), encoding);
        }
        catch (Exception e) {
            logger.warn((Object)("Catch exception while get method to url[" + url + "]"), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] get(String url) {
        client.getParams().setCookiePolicy("ignoreCookies");
        GetMethod method = new GetMethod(url);
        method.setRequestHeader(GWJ_CID, GwjConfig.GWJ_CID);
        method.setRequestHeader(GWJ_CODE, GwjConfig.GWJ_CODE);
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                logger.warn((Object)("Http response status is not OK [" + statusCode + "]"));
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = method.getResponseBody();
            return byArray;
        }
        catch (Exception e) {
            logger.warn((Object)("Catch exception while get to url [" + url + "]"), (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    static {
        GWJ_CID = "gwj-cid";
        GWJ_CODE = "gwj-code";
        HttpConnectionManagerParams params = HttpUtil.loadHttpConfFromFile();
        connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.setParams(params);
        client = new HttpClient(connectionManager);
    }
}

