/*
 * Decompiled with CFR 0.152.
 */
package com.unionpay.acp.sdk;

import com.unionpay.acp.sdk.CertInfo;
import com.unionpay.acp.sdk.LogUtil;
import com.unionpay.acp.sdk.SDKConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertUtil {
    private static KeyStore keyStore = null;
    private static X509Certificate encryptCert = null;
    private static X509Certificate encryptTrackCert = null;
    private static X509Certificate validateCert = null;
    private static Map<String, X509Certificate> certMap = new HashMap<String, X509Certificate>();
    private static KeyStore certKeyStore = null;

    public static void init() {
        CertUtil.initSignCert();
        CertUtil.initEncryptCert();
        CertUtil.initValidateCertFromDir();
    }

    public static void initSignCert() {
        LogUtil.writeLog("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u5f00\u59cb");
        if (null != keyStore) {
            keyStore = null;
        }
        try {
            keyStore = CertUtil.getKeyInfo(SDKConfig.getConfig().getSignCertPath(), SDKConfig.getConfig().getSignCertPwd(), SDKConfig.getConfig().getSignCertType());
        }
        catch (IOException e) {
            LogUtil.writeErrorLog("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25", e);
        }
        LogUtil.writeLog("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u7ed3\u675f");
    }

    public static void initSignCert(String certFilePath, String certPwd) {
        LogUtil.writeLog("\u52a0\u8f7d\u8bc1\u4e66\u6587\u4ef6[" + certFilePath + "]\u548c\u8bc1\u4e66\u5bc6\u7801[" + certPwd + "]\u7684\u7b7e\u540d\u8bc1\u4e66\u5f00\u59cb.");
        File files = new File(certFilePath);
        if (!files.exists()) {
            LogUtil.writeLog("\u8bc1\u4e66\u6587\u4ef6\u4e0d\u5b58\u5728,\u521d\u59cb\u5316\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25.");
            return;
        }
        if (null != certKeyStore) {
            certKeyStore = null;
        }
        try {
            certKeyStore = CertUtil.getKeyInfo(certFilePath, certPwd, "PKCS12");
        }
        catch (IOException e) {
            LogUtil.writeErrorLog("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25", e);
        }
        LogUtil.writeLog("\u52a0\u8f7d\u8bc1\u4e66\u6587\u4ef6[" + certFilePath + "]\u548c\u8bc1\u4e66\u5bc6\u7801[" + certPwd + "]\u7684\u7b7e\u540d\u8bc1\u4e66\u7ed3\u675f.");
    }

    public static void initEncryptCert() {
        LogUtil.writeLog("\u52a0\u8f7d\u5bc6\u7801\u52a0\u5bc6\u8bc1\u4e66\u5f00\u59cb");
        encryptCert = CertUtil.initCert(SDKConfig.getConfig().getEncryptCertPath());
        encryptTrackCert = CertUtil.initCert(SDKConfig.getConfig().getEncryptTrackCertPath());
        LogUtil.writeLog("\u52a0\u8f7d\u5bc6\u7801\u52a0\u5bc6\u8bc1\u4e66\u7ed3\u675f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate initCert(String path) {
        X509Certificate encryptCertTemp = null;
        if (null == path || "".equals(path)) {
            LogUtil.writeLog("\u52a0\u8f7d\u5bc6\u7801\u52a0\u5bc6\u8bc1\u4e66\u8def\u5f84\u662f\u7a7a");
            return encryptCertTemp;
        }
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            in = new FileInputStream(path);
            encryptCertTemp = (X509Certificate)cf.generateCertificate(in);
            LogUtil.writeLog("[" + path + "][serialNumber=" + encryptCertTemp.getSerialNumber().toString() + "]");
        }
        catch (CertificateException e) {
            LogUtil.writeErrorLog(path + "\u52a0\u5bc6\u8bc1\u4e66\u52a0\u8f7d\u5931\u8d25", e);
        }
        catch (FileNotFoundException e) {
            LogUtil.writeErrorLog(path + "\u52a0\u5bc6\u8bc1\u4e66\u52a0\u8f7d\u5931\u8d25,\u6587\u4ef6\u4e0d\u5b58\u5728", e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogUtil.writeErrorLog(e.toString());
                }
            }
        }
        return encryptCertTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initValidateCertFromDir() {
        LogUtil.writeLog("\u4ece\u76ee\u5f55\u4e2d\u52a0\u8f7d\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u5f00\u59cb.");
        certMap.clear();
        String filePath = SDKConfig.getConfig().getValidateCertDir();
        if (null == filePath || "".equals(filePath)) {
            LogUtil.writeLog("\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84\u914d\u7f6e\u4e3a\u7a7a.");
            return;
        }
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            File fileDir = new File(filePath);
            File[] files = fileDir.listFiles(new CerFilter());
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                in = new FileInputStream(file.getAbsolutePath());
                validateCert = (X509Certificate)cf.generateCertificate(in);
                certMap.put(validateCert.getSerialNumber().toString(), validateCert);
                LogUtil.writeLog("[" + file.getAbsolutePath() + "][serialNumber=" + validateCert.getSerialNumber().toString() + "]");
            }
        }
        catch (CertificateException e) {
            LogUtil.writeErrorLog("\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u52a0\u8f7d\u5931\u8d25", e);
        }
        catch (FileNotFoundException e) {
            LogUtil.writeErrorLog("\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u52a0\u8f7d\u5931\u8d25,\u8bc1\u4e66\u6587\u4ef6\u4e0d\u5b58\u5728", e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogUtil.writeErrorLog(e.toString());
                }
            }
        }
        LogUtil.writeLog("\u4ece\u76ee\u5f55\u4e2d\u52a0\u8f7d\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u7ed3\u675f.");
    }

    public static PrivateKey getSignCertPrivateKey() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, SDKConfig.getConfig().getSignCertPwd().toCharArray());
            return privateKey;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u7684\u79c1\u94a5\u5931\u8d25", e);
            return null;
        }
    }

    public static PrivateKey getSignCertPrivateKey(CertInfo certInfo) {
        try {
            keyStore = certInfo.getKeyStore();
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, certInfo.getPassword().toCharArray());
            return privateKey;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u7684\u79c1\u94a5\u5931\u8d25", e);
            return null;
        }
    }

    public static PrivateKey getSignCertPrivateKey(String certPath, String certPwd) {
        CertUtil.initSignCert(certPath, certPwd);
        try {
            Enumeration<String> aliasenum = certKeyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)certKeyStore.getKey(keyAlias, certPwd.toCharArray());
            return privateKey;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6[" + certPath + "]\u7684\u7b7e\u540d\u8bc1\u4e66\u7684\u79c1\u94a5\u5931\u8d25", e);
            return null;
        }
    }

    public static PublicKey getEncryptCertPublicKey() {
        String path = SDKConfig.getConfig().getEncryptCertPath();
        try {
            if (null == encryptCert) {
                encryptCert = CertUtil.initCert(path);
            }
            return encryptCert.getPublicKey();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u52a0\u5bc6\u8bc1\u4e66\u5931\u8d25" + path, e);
            return null;
        }
    }

    public static PublicKey getEncryptTrackCertPublicKey() {
        String path = SDKConfig.getConfig().getEncryptTrackCertPath();
        try {
            if (null == path) {
                LogUtil.writeErrorLog("\u78c1\u9053\u52a0\u5bc6\u8bc1\u4e66\u6ca1\u6709\u914d\u5236");
                return null;
            }
            if (null == encryptTrackCert) {
                encryptTrackCert = CertUtil.initCert(path);
            }
            return encryptTrackCert.getPublicKey();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u78c1\u9053\u52a0\u5bc6\u8bc1\u4e66\u5931\u8d25" + path, e);
            return null;
        }
    }

    public static PublicKey getValidateKey() {
        try {
            if (null == validateCert) {
                return null;
            }
            return validateCert.getPublicKey();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25", e);
            return null;
        }
    }

    public static PublicKey getValidateKey(String certId) {
        X509Certificate cf = null;
        if (certMap.containsKey(certId)) {
            cf = certMap.get(certId);
            return cf.getPublicKey();
        }
        CertUtil.initValidateCertFromDir();
        if (certMap.containsKey(certId)) {
            cf = certMap.get(certId);
            return cf.getPublicKey();
        }
        LogUtil.writeErrorLog("\u6ca1\u6709certId=[" + certId + "]\u5bf9\u5e94\u7684\u9a8c\u7b7e\u8bc1\u4e66\u6587\u4ef6,\u8fd4\u56deNULL.");
        return null;
    }

    public static String getSignCertId() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u7684\u5e8f\u5217\u53f7\u5931\u8d25", e);
            if (null == keyStore) {
                LogUtil.writeErrorLog("keyStore\u5b9e\u4f8b\u5316\u5931\u8d25,\u5f53\u524d\u4e3aNULL");
            }
            return "";
        }
    }

    public static String getSignCertId(KeyStore keyStore) {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u7684\u5e8f\u5217\u53f7\u5931\u8d25", e);
            if (null == keyStore) {
                LogUtil.writeErrorLog("keyStore\u5b9e\u4f8b\u5316\u5931\u8d25,\u5f53\u524d\u4e3aNULL");
            }
            return "";
        }
    }

    public static String getEncryptCertId() {
        try {
            if (null == encryptCert) {
                encryptCert = CertUtil.initCert(SDKConfig.getConfig().getEncryptCertPath());
            }
            return encryptCert.getSerialNumber().toString();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u52a0\u5bc6\u8bc1\u4e66\u7684\u5e8f\u5217\u53f7\u5931\u8d25", e);
            return "";
        }
    }

    public static String getEncryptTrackCertId() {
        try {
            if (null == encryptTrackCert) {
                encryptTrackCert = CertUtil.initCert(SDKConfig.getConfig().getEncryptTrackCertPath());
            }
            return encryptTrackCert.getSerialNumber().toString();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u52a0\u5bc6\u78c1\u9053\u8bc1\u4e66\u7684\u5e8f\u5217\u53f7\u5931\u8d25", e);
            return "";
        }
    }

    public static PublicKey getSignPublicKey() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            Certificate cert = keyStore.getCertificate(keyAlias);
            PublicKey pubkey = cert.getPublicKey();
            return pubkey;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog(e.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyInfo(String pfxkeyfile, String keypwd, String type) throws IOException {
        FileInputStream fis = null;
        try {
            LogUtil.writeLog("KeyStore Loading Start...");
            KeyStore ks = null;
            if ("JKS".equals(type)) {
                ks = KeyStore.getInstance(type);
            } else if ("PKCS12".equals(type)) {
                Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
                Security.addProvider((Provider)new BouncyCastleProvider());
                ks = KeyStore.getInstance(type);
            }
            LogUtil.writeLog("\u4f20\u5165\u7684\u79c1\u94a5\u8bc1\u4e66\u8def\u5f84\u4e3a=>[" + pfxkeyfile + "],\u5bc6\u7801=[" + keypwd + "]");
            fis = new FileInputStream(pfxkeyfile);
            char[] nPassword = null;
            char[] cArray = nPassword = null == keypwd || "".equals(keypwd.trim()) ? null : keypwd.toCharArray();
            if (null != ks) {
                ks.load(fis, nPassword);
            }
            LogUtil.writeLog("KeyStore Loading End...");
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            if (Security.getProvider("BC") == null) {
                LogUtil.writeLog("BC Provider not installed.");
            }
            LogUtil.writeErrorLog("\u8bfb\u53d6\u79c1\u94a5\u8bc1\u4e66\u5931\u8d25", e);
            if (e instanceof KeyStoreException && "PKCS12".equals(type)) {
                Security.removeProvider("BC");
            }
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            if (null != fis) {
                fis.close();
            }
        }
    }

    public static void printSysInfo() {
        System.out.println("======================= SYS INFO begin===========================");
        System.out.println("java_vendor:" + System.getProperty("java.vendor"));
        System.out.println("java_vendor_url:" + System.getProperty("java.vendor.url"));
        System.out.println("java_home:" + System.getProperty("java.home"));
        System.out.println("java_class_version:" + System.getProperty("java.class.version"));
        System.out.println("java_class_path:" + System.getProperty("java.class.path"));
        System.out.println("os_name:" + System.getProperty("os.name"));
        System.out.println("os_arch:" + System.getProperty("os.arch"));
        System.out.println("os_version:" + System.getProperty("os.version"));
        System.out.println("user_name:" + System.getProperty("user.name"));
        System.out.println("user_home:" + System.getProperty("user.home"));
        System.out.println("user_dir:" + System.getProperty("user.dir"));
        System.out.println("java_vm_specification_version:" + System.getProperty("java.vm.specification.version"));
        System.out.println("java_vm_specification_vendor:" + System.getProperty("java.vm.specification.vendor"));
        System.out.println("java_vm_specification_name:" + System.getProperty("java.vm.specification.name"));
        System.out.println("java_vm_version:" + System.getProperty("java.vm.version"));
        System.out.println("java_vm_vendor:" + System.getProperty("java.vm.vendor"));
        System.out.println("java_vm_name:" + System.getProperty("java.vm.name"));
        System.out.println("java_ext_dirs:" + System.getProperty("java.ext.dirs"));
        System.out.println("file_separator:" + System.getProperty("file.separator"));
        System.out.println("path_separator:" + System.getProperty("path.separator"));
        System.out.println("line_separator:" + System.getProperty("line.separator"));
        System.out.println("======================= SYS INFO end===========================");
    }

    public static String getCertIdByCertPath(String path, String pwd, String certTp) {
        KeyStore ks = null;
        try {
            ks = CertUtil.getKeyInfo(path, pwd, certTp);
        }
        catch (IOException e1) {
            LogUtil.writeErrorLog("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25", e1);
        }
        if (null == ks) {
            return "";
        }
        try {
            Enumeration<String> aliasenum = ks.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)ks.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u7684\u5e8f\u5217\u53f7\u5931\u8d25", e);
            return "";
        }
    }

    public static Map<String, X509Certificate> getCertMap() {
        return certMap;
    }

    public static void setCertMap(Map<String, X509Certificate> certMap) {
        CertUtil.certMap = certMap;
    }

    static {
        CertUtil.init();
    }

    static class CerFilter
    implements FilenameFilter {
        CerFilter() {
        }

        public boolean isCer(String name) {
            return name.toLowerCase().endsWith(".cer");
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.isCer(name);
        }
    }
}

