/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.LuminanceSource;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public final class BufferedImageLuminanceSource
extends LuminanceSource {
    private final BufferedImage image;
    private final int left;
    private final int top;
    private int[] rgbData;

    public BufferedImageLuminanceSource(BufferedImage image) {
        this(image, 0, 0, image.getWidth(), image.getHeight());
    }

    public BufferedImageLuminanceSource(BufferedImage image, int left, int top, int width, int height) {
        super(width, height);
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        if (left + width > sourceWidth || top + height > sourceHeight) {
            throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
        }
        this.image = image;
        this.left = left;
        this.top = top;
    }

    public byte[] getRow(int y, byte[] row) {
        if (y < 0 || y >= this.getHeight()) {
            throw new IllegalArgumentException("Requested row is outside the image: " + y);
        }
        int width = this.getWidth();
        if (row == null || row.length < width) {
            row = new byte[width];
        }
        if (this.rgbData == null || this.rgbData.length < width) {
            this.rgbData = new int[width];
        }
        this.image.getRGB(this.left, this.top + y, width, 1, this.rgbData, 0, width);
        for (int x = 0; x < width; ++x) {
            int pixel = this.rgbData[x];
            int luminance = 306 * (pixel >> 16 & 0xFF) + 601 * (pixel >> 8 & 0xFF) + 117 * (pixel & 0xFF) >> 10;
            row[x] = (byte)luminance;
        }
        return row;
    }

    public byte[] getMatrix() {
        int width = this.getWidth();
        int height = this.getHeight();
        int area = width * height;
        byte[] matrix = new byte[area];
        int[] rgb = new int[area];
        this.image.getRGB(this.left, this.top, width, height, rgb, 0, width);
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                int pixel = rgb[offset + x];
                int luminance = 306 * (pixel >> 16 & 0xFF) + 601 * (pixel >> 8 & 0xFF) + 117 * (pixel & 0xFF) >> 10;
                matrix[offset + x] = (byte)luminance;
            }
        }
        return matrix;
    }

    public boolean isCropSupported() {
        return true;
    }

    public LuminanceSource crop(int left, int top, int width, int height) {
        return new BufferedImageLuminanceSource(this.image, left, top, width, height);
    }

    public boolean isRotateSupported() {
        return this.image.getType() != 0;
    }

    public LuminanceSource rotateCounterClockwise() {
        if (!this.isRotateSupported()) {
            throw new IllegalStateException("Rotate not supported");
        }
        int sourceWidth = this.image.getWidth();
        int sourceHeight = this.image.getHeight();
        AffineTransform transform = new AffineTransform(0.0, -1.0, 1.0, 0.0, 0.0, (double)sourceWidth);
        AffineTransformOp op = new AffineTransformOp(transform, 1);
        BufferedImage rotatedImage = new BufferedImage(sourceHeight, sourceWidth, this.image.getType());
        op.filter(this.image, rotatedImage);
        int width = this.getWidth();
        return new BufferedImageLuminanceSource(rotatedImage, this.top, sourceWidth - (this.left + width), this.getHeight(), width);
    }
}

